//
//  CRAttachedWindowController.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 3/6/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "MAAttachedWindow.h"

//////////////////////////////////////////////////////////////////////
// Attached window controller
//////////////////////////////////////////////////////////////////////
@interface CRAttachedWindowController : NSWindowController<NSWindowDelegate>
{
	Class				attachedWindowClass;
	
@protected
	NSView*				rootView;
	BOOL				isAttached;
	MAAttachedWindow*	attachedWindow;
	NSViewController*	viewController;
	id					delegate;
	
	NSWindow* assigned	rootWindow;
}

@property (nonatomic, assign) BOOL	isAttached;
@property (nonatomic, assign) Class	attachedWindowClass;

- (BOOL)isAttachedToView:(NSView *)aView;

- (void)attachViewController:(NSViewController *)aController toView:(NSView *)anchorView;
- (void)attachViewController:(NSViewController *)aController toView:(NSView *)anchorView onSide:(MAWindowPosition)position withOffset:(NSPoint)offset atDistance:(CGFloat)aDistance;

- (void)detach;

@end